﻿using System;
using System.IO;
using System.Net;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections.Generic;

/*
 * ActivityTimeline REST API Basic C# .NET 4.0 Sample. 
 *
 * AT REST API Sample for ActivityTimeline v7.3.0 and above.
 * 
 * Documentation: https://activitytimeline.atlassian.net/wiki/spaces/AC/pages/45561771/ActivityTimeline+REST+API
 *
 */
namespace AT_REST_API_Sample.NET
{
	class ActivityTimelineRestAPISample
	{
		
		static String ATBaseURL = "https://your-instance-name.connect.activitytimeline.com";
		static String activityTimelineAuthToken = "<your_token>";

		static String teamListRESTmethod = "/rest/api/1/team/list";

		
		public static void Main(string[] args)
		{
			Console.WriteLine("ActivityTimeline REST API Sample\n");

			Console.WriteLine("Login...\n");
			ActivityTimelineRestAPISample pr = new ActivityTimelineRestAPISample();
			
			Console.WriteLine("\nGetting the list of teams...\n");
			
			// get the list of teams by AT REST API (pass previously received authorized session data): 
			var response1 = pr.GET(ATBaseURL + teamListRESTmethod, null);
			
			StreamReader reader = new StreamReader(response1.GetResponseStream());
			string teamListJsonData = reader.ReadToEnd();			
			
			// print received team JSON data:
			Console.WriteLine("Received Teams JSON Data:\n" + teamListJsonData);			
			
			Console.Write("\nPress any key to continue . . . ");
			Console.ReadKey(true);
		}
						
		
		private HttpWebResponse POST(string url, string postData, string referer)
		{
			
			byte[] byteArray = Encoding.UTF8.GetBytes(postData);
			HttpWebRequest request = (HttpWebRequest)HttpWebRequest.Create(url);
			request.Headers.Add("auth_token: " + activityTimelineAuthToken);
			request.Method = "POST";
			request.KeepAlive = true;
			request.AllowAutoRedirect = false;
			request.Accept = "*/*";			
			request.ContentType = "application/json";			
			if (!string.IsNullOrEmpty(referer))
				request.Referer = referer;
			request.ContentLength = byteArray.Length;
			request.UserAgent = "Mozilla/5.0 (Windows; U; Windows NT 6.0; en-US; rv:1.9.0.5) Gecko/2008120122 Firefox/3.0.5";
			//   request.Proxy = null;
			Stream dataStream = request.GetRequestStream();
			dataStream.Write(byteArray, 0, byteArray.Length);
			dataStream.Close();
			
			return (HttpWebResponse)request.GetResponse();
		}
		
		
		private HttpWebResponse GET(string url, string referer)
		{	
			
			HttpWebRequest request = (HttpWebRequest)HttpWebRequest.Create(url);
			request.Headers.Add("auth_token: " + activityTimelineAuthToken);
			request.Method = "GET";
			request.KeepAlive = true;
			request.AllowAutoRedirect = false;
			request.Accept = "*/*";			
			request.ContentType = "application/json";			
			if (!string.IsNullOrEmpty(referer))
				request.Referer = referer;
			
			request.UserAgent = "Mozilla/5.0 (Windows; U; Windows NT 6.0; en-US; rv:1.9.0.5) Gecko/2008120122 Firefox/3.0.5";
			//   request.Proxy = null;
			
			return (HttpWebResponse)request.GetResponse();
		}
		
	}
}