﻿using System;
using System.IO;
using System.Net;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections.Generic;

/*
 * Deprecated. 
 * Deprecated AT REST API for ActivityTimeline v7.2.6 and below.  
 *
 * ActivityTimeline REST API Basic C# .NET 4.0 Sample. 
 * 
 * Documentation: https://activitytimeline.atlassian.net/wiki/spaces/AC/pages/45561771/ActivityTimeline+REST+API
 *
 */
namespace AT_REST_API_Sample.NET
{
	class ActivityTimelineRestAPISampleDeprecated
	{
		
		static String ATBaseURL = "https://your-instance-name.activitytimeline.com";
		static String activityTimelineAuthToken = "<token>";

		static String loginRESTmethod =  "/rest/api/1/session";
		static String teamListRESTmethod = "/rest/api/1/team/list";

		
		public static void Main(string[] args)
		{
			Console.WriteLine("ActivityTimeline REST API Sample\n");

			Console.WriteLine("Login...\n");
			ActivityTimelineRestAPISampleDeprecated pr = new ActivityTimelineRestAPISampleDeprecated();

			// login into ActivityTimeline REST API: 
			string sessionCookies = pr.LoginToATRestAPI();
			
			Console.WriteLine("Session Cookies = " + sessionCookies);
			
			Console.WriteLine("\nGetting the list of teams...\n");
			
			// get the list of teams by AT REST API (pass previously received authorized session data): 
			var response1 = pr.GET(ATBaseURL + teamListRESTmethod, null, sessionCookies);
			
			StreamReader reader = new StreamReader(response1.GetResponseStream());
			string teamListJsonData = reader.ReadToEnd();			
			
			// print received team JSON data:
			Console.WriteLine("Received Teams JSON Data:\n" + teamListJsonData);			
			
			Console.Write("\nPress any key to continue . . . ");
			Console.ReadKey(true);
		}
		
		
		private string LoginToATRestAPI()
		{
			string uri = string.Empty;
			string cookie = string.Empty;
			
			HttpWebResponse response = POST(ATBaseURL + loginRESTmethod, "", null, null);
			
			// check if we received successful authorization response: 
			if (response == null || ((int)response.StatusCode) != 200)
			{				
				Console.WriteLine("Not authorized.\n");
				return "";
			}

			WebHeaderCollection headers = response.Headers;
			
			if (headers["Set-Cookie"] != null)
			{
				string cookies = headers["Set-Cookie"];
				String[] fields = Regex.Split(cookies, ";\\s*");
				cookie = fields[0];
			}
			
			return cookie;
		}
				
		
		private HttpWebResponse POST(string url, string postData, string referer, string cookie)
		{
			
			byte[] byteArray = Encoding.UTF8.GetBytes(postData);
			HttpWebRequest request = (HttpWebRequest)HttpWebRequest.Create(url);
			request.Headers.Add("auth_token: " + activityTimelineAuthToken);
			request.Method = "POST";
			request.KeepAlive = true;
			request.AllowAutoRedirect = false;
			request.Accept = "*/*";			
			request.ContentType = "application/json";
			if (!string.IsNullOrEmpty(cookie))
				request.Headers.Add(HttpRequestHeader.Cookie, cookie);
			if (!string.IsNullOrEmpty(referer))
				request.Referer = referer;
			request.ContentLength = byteArray.Length;
			request.UserAgent = "Mozilla/5.0 (Windows; U; Windows NT 6.0; en-US; rv:1.9.0.5) Gecko/2008120122 Firefox/3.0.5";
			//   request.Proxy = null;
			Stream dataStream = request.GetRequestStream();
			dataStream.Write(byteArray, 0, byteArray.Length);
			dataStream.Close();
			
			return (HttpWebResponse)request.GetResponse();
		}
		
		
		private HttpWebResponse GET(string url, string referer, string cookie)
		{	
			
			HttpWebRequest request = (HttpWebRequest)HttpWebRequest.Create(url);
			request.Headers.Add("auth_token: " + activityTimelineAuthToken);
			request.Method = "GET";
			request.KeepAlive = true;
			request.AllowAutoRedirect = false;
			request.Accept = "*/*";			
			request.ContentType = "application/json";
			if (!string.IsNullOrEmpty(cookie))
				request.Headers.Add(HttpRequestHeader.Cookie, cookie);
			if (!string.IsNullOrEmpty(referer))
				request.Referer = referer;
			
			request.UserAgent = "Mozilla/5.0 (Windows; U; Windows NT 6.0; en-US; rv:1.9.0.5) Gecko/2008120122 Firefox/3.0.5";
			//   request.Proxy = null;
			
			return (HttpWebResponse)request.GetResponse();
		}
		
	}
}