package com.activitytimeline.rest.samples;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.core.MultivaluedMap;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;


/**
 * AT REST API Sample for ActivityTimeline v7.3.0 and above.
 *
 * Documentation: https://activitytimeline.atlassian.net/wiki/spaces/AC/pages/45561771/ActivityTimeline+REST+API
 *
 */
public class ActivityTimelineRestAPISample {

    private static final String ACTIVITY_TIMELINE_URL = "http://localhost:8040";
    private static final String ACTIVITY_TIMELINE_AUTH_TOKEN = "xxxxxxxx-xxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx";

    private static final String USERNAME = "sample.user";    // Username or AccountId

    public static void main(String[] args) {
        try {

            // Uncomment the following line to accept all SSL certificates including invalid ones:
            // acceptInvalidSSLCertificates();

            JSONParser parser = new JSONParser();
            ClientResponse response;
            WebResource webResource;

            Client client = Client.create();

            JSONObject object;
            Long eventId = null;
            JSONArray array;
            Long teamId = null;
            String eventTypeId = null;
            MultivaluedMap<String, String> params = null;


            // Get ActivityTimeline Custom Event Types
            System.out.println("Get ActivityTimeline Custom Event Types:  -------------------------------------- ");
            webResource = client.resource(ACTIVITY_TIMELINE_URL + "/rest/api/1/eventType/list");
            response = webResource.header("auth_token", ACTIVITY_TIMELINE_AUTH_TOKEN).accept("application/json").get(ClientResponse.class);

            String output = response.getEntity(String.class);
            if (response.getStatus() != 200) {
                System.out.println("Failed : HTTP error code : " + response.getStatus() + " " + output);

            } else {
                array = (JSONArray) parser.parse(output);
                if (array.size() > 0) {
                    for (Object anArray : array) {
                        if ("VACATION".equals(((JSONObject) anArray).get("eventType"))) {
                            eventTypeId = (((JSONObject) anArray).get("id")).toString();
                        }
                    }
                }
                System.out.println("\nOutput from Server:");
                System.out.println(output);
            }

            // Create new Vacation event
            System.out.println("Create new Vacation event:  -------------------------------------- ");
            if (eventTypeId != null) {
                params = new MultivaluedMapImpl();
                params.add("eventTypeId", eventTypeId);           // eventTypeId is obtained from a previous request
                params.add("username", USERNAME);                 // username or AccountId (Jira Cloud)

                params.add("eventTitle", "New Year Vacation");
                params.add("start", "2020-01-01");
                params.add("end", "2020-01-01");

                // params.add("isApproved", "true");   // uncomment this line to create pre-approved item (Placeholder, Vacation or Booking)

                // Add custom event
                webResource = client.resource(ACTIVITY_TIMELINE_URL + "/rest/api/1/event");
                response = webResource.queryParams(params).header("auth_token", ACTIVITY_TIMELINE_AUTH_TOKEN).accept("application/json").post(ClientResponse.class);

                output = response.getEntity(String.class);
                if (response.getStatus() != 200) {
                    System.out.println("Failed : HTTP error code : " + response.getStatus() + " " + output);
                } else {
                    object = (JSONObject) parser.parse(output);
                    eventId = (Long) object.get("id");
                }

                System.out.println("\nOutput from Server:");
                System.out.println(output);
            }

            // Delete newly created Vacation event
            System.out.println("Delete newly created Vacation event:  -------------------------------------- ");
            if (eventId != null) {
                webResource = client.resource(ACTIVITY_TIMELINE_URL + "/rest/api/1/event/" + eventId.toString());
                response = webResource.header("auth_token", ACTIVITY_TIMELINE_AUTH_TOKEN).accept("application/json").delete(ClientResponse.class);

                if (response.getStatus() != 200) {
                    System.out.println("Failed : HTTP error code : " + response.getStatus() + " " + output);
                }

                output = response.getEntity(String.class);

                System.out.println("\nOutput from Server:");
                System.out.println(output);
            }

            // Get the list of Teams
            System.out.println("Get the list of Teams:  -------------------------------------- ");
            webResource = client.resource(ACTIVITY_TIMELINE_URL + "/rest/api/1/team/list");
            response = webResource.header("auth_token", ACTIVITY_TIMELINE_AUTH_TOKEN).accept("application/json").get(ClientResponse.class);

            output = response.getEntity(String.class);
            if (response.getStatus() != 200) {
                System.out.println("Failed : HTTP error code : " + response.getStatus() + " " + output);
            } else {
                array = (JSONArray) parser.parse(output);
                if (array.size() > 0) {
                    teamId = Long.parseLong(((JSONObject) array.get(0)).get("id").toString());
                }
                System.out.println("\nOutput from Server:");
                System.out.println(output);
            }


            // Get Team data
            System.out.println("Get Team data:  -------------------------------------- ");
            if (teamId != null) {
                webResource = client.resource(ACTIVITY_TIMELINE_URL + "/rest/api/1/team/" + teamId.toString());
                response = webResource.header("auth_token", ACTIVITY_TIMELINE_AUTH_TOKEN).accept("application/json").get(ClientResponse.class);

                if (response.getStatus() != 200) {
                    System.out.println("Failed : HTTP error code : " + response.getStatus() + " " + output);
                }

                output = response.getEntity(String.class);

                System.out.println("\nOutput from Server:");
                System.out.println(output);
            }

            // Get Team's schedule/timeline data
            System.out.println("Get Team's schedule/timeline data:  -------------------------------------- ");
            if (teamId != null) {
                webResource = client.resource(ACTIVITY_TIMELINE_URL + "/rest/api/1/timeline");
                params = new MultivaluedMapImpl();
                params.add("start", "2020-01-01");
                params.add("end", "2020-01-31");
                params.add("teamId", teamId.toString());

                // Get Timeline Schedule
                response = webResource.queryParams(params).header("auth_token", ACTIVITY_TIMELINE_AUTH_TOKEN).accept("application/json").get(ClientResponse.class);

                if (response.getStatus() != 200) {
                    System.out.println("Failed : HTTP error code : " + response.getStatus() + " " + output);
                }

                output = response.getEntity(String.class);

                System.out.println("\nOutput from Server:");
                System.out.println(output);
            }


            // Get Team's workload data
            System.out.println("Get Team's workload data:  -------------------------------------- ");
            if (teamId != null) {
                webResource = client.resource(ACTIVITY_TIMELINE_URL + "/rest/api/1/workload");
                params = new MultivaluedMapImpl();
                params.add("start", "2020-01-01");
                params.add("end", "2020-01-31");
                params.add("teamId", teamId.toString());


                // Get Workload data
                response = webResource.queryParams(params).header("auth_token", ACTIVITY_TIMELINE_AUTH_TOKEN).accept("application/json").get(ClientResponse.class);

                if (response.getStatus() != 200) {
                    System.out.println("Failed : HTTP error code : " + response.getStatus() + " " + output);
                }

                output = response.getEntity(String.class);

                System.out.println("\nOutput from Server:");
                System.out.println(output);
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

        System.out.println("\nEnd of AT REST API calls.");
    }


    private static void acceptInvalidSSLCertificates() {
        // Create a trust manager that does not validate certificate chains
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){
            public X509Certificate[] getAcceptedIssuers(){return null;}
            public void checkClientTrusted(X509Certificate[] certs, String authType){}
            public void checkServerTrusted(X509Certificate[] certs, String authType){}
        }};

        // Install the all-trusting trust manager
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        } catch (Exception e) {

        }
    }
}
