package com.activitytimeline.rest.samples;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import java.util.List;


/**
 * @deprecated
 * Deprecated AT REST API for ActivityTimeline v7.2.6 and below.
 *
 * Documentation: https://activitytimeline.atlassian.net/wiki/spaces/AC/pages/45561771/ActivityTimeline+REST+API
 *
 */
public class ActivityTimelineRestAPISampleDeprecated {

    private static final String ACTIVITY_TIMELINE_URL = "http://localhost:8040";
    private static final String ACTIVITY_TIMELINE_USERNAME = "admin";
    private static final String ACTIVITY_TIMELINE_PASSWORD = "<password>";


    public static void main(String[] args) {
        try {

            JSONParser parser = new JSONParser();

            Client client = Client.create();

            // Login with ActivityTimeline Admin User credentials
            System.out.println("Login with ActivityTimeline Admin User credentials:  -------------------------------------- ");
            WebResource webResource = client.resource(ACTIVITY_TIMELINE_URL + "/rest/api/1/session");
            String input = "{\"username\":\"" + ACTIVITY_TIMELINE_USERNAME + "\",\"password\":\"" + ACTIVITY_TIMELINE_PASSWORD + "\"}";

            // Create Session (login to ActivityTimeline REST API)
            ClientResponse response = webResource.type("application/json").post(ClientResponse.class, input);

            List<NewCookie> cookiesList = response.getCookies();
            String jsessionId = null;
            for (NewCookie cookie : cookiesList) {
                if ("JSESSIONID".equals(cookie.getName()) || "AT_JSESSIONID".equals(cookie.getName())) {
                    jsessionId = cookie.getValue();
                }
            }

            if (response.getStatus() != 200) {
                System.out.println("Failed : HTTP error code : " + response.getStatus());
            } else {
                System.out.println("Logged in. Session ID = " + jsessionId);
            }

            JSONObject object;
            Long eventId = null;
            JSONArray array;
            Long teamId = null;
            String eventTypeId = null;
            MultivaluedMap<String, String> params = null;


            // Get ActivityTimeline Custom Event Types
            System.out.println("Get ActivityTimeline Custom Event Types:  -------------------------------------- ");
            webResource = client.resource(ACTIVITY_TIMELINE_URL + "/rest/api/1/eventType/list");
            response = webResource.cookie(new Cookie("JSESSIONID", jsessionId)).cookie(new Cookie("AT_JSESSIONID", jsessionId)).accept("application/json").get(ClientResponse.class);

            String output = response.getEntity(String.class);
            if (response.getStatus() != 200) {
                System.out.println("Failed : HTTP error code : " + response.getStatus() + " " + output);

            } else {
                array = (JSONArray) parser.parse(output);
                if (array.size() > 0) {
                    for (Object anArray : array) {
                        if ("VACATION".equals(((JSONObject) anArray).get("eventType"))) {
                            eventTypeId = (((JSONObject) anArray).get("id")).toString();
                        }
                    }
                }
                System.out.println("\nOutput from Server:");
                System.out.println(output);
            }

            // Create new Vacation event
            System.out.println("Create new Vacation event:  -------------------------------------- ");
            if (eventTypeId != null) {
                params = new MultivaluedMapImpl();
                params.add("eventTypeId", eventTypeId);   // eventTypeId is obtained from a previous request
                params.add("username", "sample.user");

                params.add("eventTitle", "Summer Vacation");
                params.add("start", "2019-08-04");
                params.add("end", "2019-08-04");

                params.add("isApproved", "true");   // uncomment this line to create pre-approved item (Placeholder, Vacation or Booking)

                // Add custom event
                webResource = client.resource(ACTIVITY_TIMELINE_URL + "/rest/api/1/event");
                response = webResource.queryParams(params).cookie(new Cookie("JSESSIONID", jsessionId)).cookie(new Cookie("AT_JSESSIONID", jsessionId)).accept("application/json").post(ClientResponse.class);

                output = response.getEntity(String.class);
                if (response.getStatus() != 200) {
                    System.out.println("Failed : HTTP error code : " + response.getStatus() + " " + output);
                } else {
                    object = (JSONObject) parser.parse(output);
                    eventId = (Long) object.get("id");
                }

                System.out.println("\nOutput from Server:");
                System.out.println(output);
            }

            // Delete newly created Vacation event
            System.out.println("Delete newly created Vacation event:  -------------------------------------- ");
            if (eventId != null) {
                webResource = client.resource(ACTIVITY_TIMELINE_URL + "/rest/api/1/event/" + eventId.toString());
                response = webResource.cookie(new Cookie("JSESSIONID", jsessionId)).cookie(new Cookie("AT_JSESSIONID", jsessionId)).accept("application/json").delete(ClientResponse.class);

                if (response.getStatus() != 200) {
                    System.out.println("Failed : HTTP error code : " + response.getStatus() + " " + output);
                }

                output = response.getEntity(String.class);

                System.out.println("\nOutput from Server:");
                System.out.println(output);
            }

            // Get the list of Teams
            System.out.println("Get the list of Teams:  -------------------------------------- ");
            webResource = client.resource(ACTIVITY_TIMELINE_URL + "/rest/api/1/team/list");
            response = webResource.cookie(new Cookie("JSESSIONID", jsessionId)).cookie(new Cookie("AT_JSESSIONID", jsessionId)).accept("application/json").get(ClientResponse.class);

            output = response.getEntity(String.class);
            if (response.getStatus() != 200) {
                System.out.println("Failed : HTTP error code : " + response.getStatus() + " " + output);
            } else {
                array = (JSONArray) parser.parse(output);
                if (array.size() > 0) {
                    teamId = Long.parseLong(((JSONObject) array.get(0)).get("id").toString());
                }
                System.out.println("\nOutput from Server:");
                System.out.println(output);
            }


            // Get Team data
            System.out.println("Get Team data:  -------------------------------------- ");
            if (teamId != null) {
                webResource = client.resource(ACTIVITY_TIMELINE_URL + "/rest/api/1/team/" + teamId.toString());
                response = webResource.cookie(new Cookie("JSESSIONID", jsessionId)).cookie(new Cookie("AT_JSESSIONID", jsessionId)).accept("application/json").get(ClientResponse.class);

                if (response.getStatus() != 200) {
                    System.out.println("Failed : HTTP error code : " + response.getStatus() + " " + output);
                }

                output = response.getEntity(String.class);

                System.out.println("\nOutput from Server:");
                System.out.println(output);
            }

            // Get Team's schedule/timeline data
            System.out.println("Get Team's schedule/timeline data:  -------------------------------------- ");
            if (teamId != null) {
                webResource = client.resource(ACTIVITY_TIMELINE_URL + "/rest/api/1/timeline");
                params = new MultivaluedMapImpl();
                params.add("start", "2019-10-22");
                params.add("end", "2019-10-29");
                params.add("teamId", teamId.toString());


                // Get Timeline Schedule
                response = webResource.queryParams(params).cookie(new Cookie("JSESSIONID", jsessionId)).cookie(new Cookie("AT_JSESSIONID", jsessionId)).accept("application/json").get(ClientResponse.class);

                if (response.getStatus() != 200) {
                    System.out.println("Failed : HTTP error code : " + response.getStatus() + " " + output);
                }

                output = response.getEntity(String.class);

                System.out.println("\nOutput from Server:");
                System.out.println(output);
            }


            // Get Team's workload data
            System.out.println("Get Team's workload data:  -------------------------------------- ");
            if (teamId != null) {
                webResource = client.resource(ACTIVITY_TIMELINE_URL + "/rest/api/1/workload");
                params = new MultivaluedMapImpl();
                params.add("start", "2019-04-01");
                params.add("end", "2019-04-14");
                params.add("teamId", teamId.toString());


                // Get Workload data
                response = webResource.queryParams(params).cookie(new Cookie("JSESSIONID", jsessionId)).cookie(new Cookie("AT_JSESSIONID", jsessionId)).accept("application/json").get(ClientResponse.class);

                if (response.getStatus() != 200) {
                    System.out.println("Failed : HTTP error code : " + response.getStatus() + " " + output);
                }

                output = response.getEntity(String.class);

                System.out.println("\nOutput from Server:");
                System.out.println(output);
            }

            // Logout
            System.out.println("Logout:  -------------------------------------- ");
            webResource = client.resource(ACTIVITY_TIMELINE_URL + "/rest/api/1/session");
            response = webResource.cookie(new Cookie("JSESSIONID", jsessionId)).cookie(new Cookie("AT_JSESSIONID", jsessionId)).accept("application/json").delete(ClientResponse.class);

            output = response.getEntity(String.class);
            if (response.getStatus() != 200) {
                System.out.println("Failed : HTTP error code : " + response.getStatus() + " " + output);
            }
            System.out.println("\nOutput from Server:");
            System.out.println(output);

        } catch (Exception e) {
            e.printStackTrace();
        }

        System.out.println("\nEnd of AT REST API calls.");
    }
}
